#include <iostream>
#include <cstdlib>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <queue>
#include <ctime>
#include <cassert>
#include <string>
#include <cstdlib>
#include <cstring>
#include <algorithm>
#include <memory.h>

#define pb push_back
#define mp make_pair
#define fr first
#define sc second

using namespace std;

const int N = 1e4 + 10;
const int INF = 1e9;

struct edge {
	int v, f, mf, pid;
	edge() { }
	edge(int v, int f, int mf, int pid): v(v), f(f), mf(mf), pid(pid) { }
};



int n, m, s, t;	
vector < edge > e[N];
vector < int > ee[N];
vector < int > er[N];
int dist[N];
queue < int > q;
int p[N];
int pid[N];
bool use1[N];
bool use2[N];

void addEdge(int v, int u) {
	int vSz = e[v].size();
	int uSz = e[u].size();
	e[v].pb(edge(u, 0, 1, uSz));
	e[u].pb(edge(v, 0, 0, vSz));
}

bool bfs() {
	memset(dist, 63, sizeof(dist));
	dist[s] = 0;
	q.push(s);
	while (!q.empty()) {
		int v = q.front();
		q.pop();
		for (int i = 0; i < (int)e[v].size(); i++) {
			auto x = e[v][i];
			if (dist[x.v] > dist[v] + 1 && x.f < x.mf) {
				dist[x.v] = dist[v] + 1;
				p[x.v] = v;
				pid[x.v] = i;
				q.push(x.v);
			}
		}
	}
	if (dist[t] > INF) return 0;
	int v = t;
	for (;v != s;) {
		int u = p[v];
		e[u][pid[v]].f++;
		e[v][e[u][pid[v]].pid].f--;
		v = u;
	}
	return 1;
}

void dfs(int v, vector < int > * e, bool * use) {
	use[v] = 1;
	for (auto u: e[v])
		if (!use[u])
			dfs(u, e, use);
}

int main() {
#ifdef DEBUG
	freopen("in", "r", stdin);
#endif
	while (true) {
		scanf("%d%d%d%d", &n, &m, &s, &t); s--; t--;
		if (n == 0) return 0;
		for (int i = 0; i < n; i++) {
			e[i].clear();
			ee[i].clear();
			er[i].clear();
		}
		
		for (int i = 0; i < m; i++) {
			int v, u;
			scanf("%d%d", &v, &u); v--; u--;
			addEdge(v, u);
		}
		int res = 0;
		for (;;) {
			int t = bfs();
			res += t;
			if (t == 0) break;
		}
		vector < pair < int, int > > d;
		vector < pair < int, int > > dd;
		for (int i = 0; i < n; i++) {
			for (int j = 0; j < (int)e[i].size(); j++) {
				if (e[i][j].f < e[i][j].mf) {
					d.pb(mp(i, e[i][j].v));
				}
				if (e[i][j].f == 0 && e[i][j].mf == 1)
					dd.pb(mp(i, e[i][j].v));
			}
		}

		
		
		for (auto x: d)
			ee[x.fr].pb(x.sc);
		for (auto x: d)
			er[x.sc].pb(x.fr);

		memset(use1, 0, sizeof(use1));
		memset(use2, 0, sizeof(use2));
		dfs(s, ee, use1);
		dfs(t, er, use2);
		for (int i = 0; i < n; i++)
			assert(!(use1[i] && use2[i]));

		int cnt = 0;
		for (auto x: dd) {
			if (use1[x.sc] && use2[x.fr])
				cnt++;
		}

		if (cnt == 0) {
			printf("%d %d\n", res, cnt);
		}
		else {
			res++;
			printf("%d %d\n", res, cnt);
		}
	}
	return 0;
}


